<?php

if (!defined('ABSPATH')) {
    exit;
}

class Ultimate_AI_Onboarding_Controller
{
    public function __construct()
    {
        add_action('wp_ajax_ultimate_ai_save_welcome_note', [$this, 'ultimate_ai_save_welcome_note']);
        add_action('wp_ajax_ultimate_ai_get_welcome_note', [$this, 'ultimate_ai_get_welcome_note']);
    }

    public function ultimate_ai_get_welcome_note()
    {
        $menu = get_option('ultimate_ai_complete_activation_text', []);
        wp_send_json($menu, 200);
    }

    public function ultimate_ai_save_welcome_note()
    {
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Permission denied', 403);
        }
        $activation_text = isset($_POST['activation_text']) ? $_POST['activation_text'] : '';

        if (!$this->option_exists('ultimate_ai_complete_activation_text')) {
            add_option('ultimate_ai_complete_activation_text', $activation_text);
        } else {
            update_option('ultimate_ai_complete_activation_text', $activation_text);
        }
        $activation_text = get_option('ultimate_ai_complete_activation_text', '');

        wp_send_json($activation_text, 200);
    }

    public function option_exists($name, $site_wide = false)
    {
        global $wpdb;

        return $wpdb->query('SELECT * FROM '.($site_wide ? $wpdb->base_prefix : $wpdb->prefix)."options WHERE option_name ='$name' LIMIT 1");
    }
}

new Ultimate_AI_Onboarding_Controller();
